import { Link } from "@tanstack/react-router"

import { cn } from "@/lib/utils"
import { ComponentClassName } from "@/types/utility"
import { ComponentProps } from "react"

const SITE_TITLE = 'MDOT'

export type LogoProps = Omit<ComponentProps<typeof Link>, "to" | "children"> & Pick<ComponentClassName, "className">

export function Logo({ className, ...props }: LogoProps) {
    return (
      <Link 
        to="/" 
        className={cn("text-strong-foreground mr-6 flex items-center space-x-1", className)}
        {...props}
      >
        <div className="text-base font-bold">
          {SITE_TITLE}
        </div>
      </Link>
    )
}